

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto">
    <!-- Header -->
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-800">
            <i class="fas fa-microchip text-blue-500 mr-3"></i>Sensor Data Monitoring
        </h1>
        <p class="text-gray-600 mt-2">Real-time monitoring of temperature, humidity, and soil moisture sensors</p>
    </div>

    <!-- Current Readings -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <!-- Temperature Card -->
        <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-red-500">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">Temperature</h3>
                    <p class="text-sm text-gray-500">DS18B20 Sensor</p>
                </div>
                <i class="fas fa-thermometer-half text-red-500 text-3xl"></i>
            </div>
            <div class="text-center">
                <p class="text-4xl font-bold text-gray-800" id="live-temperature">
                    <?php echo e($latestData->temperature ?? '0'); ?>°
                </p>
                <p class="text-gray-600 mt-2">Celsius</p>
            </div>
            <div class="mt-4 text-sm text-gray-500">
                <i class="far fa-clock mr-1"></i>
                Updated: <span id="temp-timestamp"><?php echo e($latestData->updated_at->format('H:i:s') ?? '--:--:--'); ?></span>
            </div>
        </div>

        <!-- Humidity Card -->
        <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">Humidity</h3>
                    <p class="text-sm text-gray-500">DHT22 Sensor</p>
                </div>
                <i class="fas fa-tint text-blue-500 text-3xl"></i>
            </div>
            <div class="text-center">
                <p class="text-4xl font-bold text-gray-800" id="live-humidity">
                    <?php echo e($latestData->humidity ?? '0'); ?>%
                </p>
                <p class="text-gray-600 mt-2">Relative Humidity</p>
            </div>
            <div class="mt-4 text-sm text-gray-500">
                <i class="far fa-clock mr-1"></i>
                Updated: <span id="humidity-timestamp"><?php echo e($latestData->updated_at->format('H:i:s') ?? '--:--:--'); ?></span>
            </div>
        </div>

        <!-- Soil Moisture Card -->
        <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">Soil Moisture</h3>
                    <p class="text-sm text-gray-500">Capacitive Sensor</p>
                </div>
                <i class="fas fa-seedling text-green-500 text-3xl"></i>
            </div>
            <div class="text-center">
                <p class="text-4xl font-bold text-gray-800" id="live-soil-moisture">
                    <?php echo e($latestData->soil_moisture ?? '0'); ?>

                </p>
                <p class="text-gray-600 mt-2">Raw Value (0-1023)</p>
            </div>
            <div class="mt-4">
                <div class="bg-gray-200 rounded-full h-2">
                    <div class="bg-gradient-to-r from-green-500 via-yellow-500 to-red-500 h-2 rounded-full" 
                         style="width: <?php echo e(min(($latestData->soil_moisture ?? 0) / 10.23, 100)); ?>%"></div>
                </div>
                <div class="flex justify-between text-xs text-gray-500 mt-1">
                    <span>Wet</span>
                    <span>Optimal</span>
                    <span>Dry</span>
                </div>
            </div>
            <div class="mt-4 text-sm text-gray-500">
                <i class="far fa-clock mr-1"></i>
                Updated: <span id="soil-timestamp"><?php echo e($latestData->updated_at->format('H:i:s') ?? '--:--:--'); ?></span>
            </div>
        </div>
    </div>

    <!-- Data Table -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h2 class="text-xl font-semibold text-gray-800">
                <i class="fas fa-table text-blue-500 mr-2"></i>Historical Data
            </h2>
            <p class="text-gray-600 text-sm mt-1">Last 50 sensor readings</p>
        </div>
        
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Timestamp
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Temperature (°C)
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Humidity (%)
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Soil Moisture
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200" id="sensor-data-body">
                    <?php $__empty_1 = true; $__currentLoopData = $sensorData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-800">
                            <?php echo e($data->created_at->format('Y-m-d H:i:s')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="text-sm font-medium text-gray-900">
                                    <?php echo e($data->temperature); ?>°
                                </div>
                                <?php if($data->temperature > 30): ?>
                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                    Hot
                                </span>
                                <?php elseif($data->temperature < 15): ?>
                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                    Cold
                                </span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="text-sm font-medium text-gray-900">
                                    <?php echo e($data->humidity); ?>%
                                </div>
                                <?php if($data->humidity > 70): ?>
                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                    High
                                </span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="text-sm font-medium text-gray-900">
                                    <?php echo e($data->soil_moisture); ?>

                                </div>
                                <?php if($data->soil_moisture > 700): ?>
                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                    Dry
                                </span>
                                <?php elseif($data->soil_moisture < 300): ?>
                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                    Wet
                                </span>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <?php if($data->soil_moisture > 700 && $data->temperature > 25): ?>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                Needs Watering
                            </span>
                            <?php elseif($data->soil_moisture < 300): ?>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                Well Watered
                            </span>
                            <?php else: ?>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                                Normal
                            </span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            <i class="fas fa-database text-3xl mb-2 block"></i>
                            No sensor data available yet
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Table Footer -->
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
            <div class="flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    <i class="fas fa-info-circle mr-2"></i>
                    Showing last <?php echo e($sensorData->count()); ?> readings
                </div>
                <div class="text-sm text-gray-600">
                    Auto-refresh in <span id="refresh-countdown">10</span>s
                </div>
            </div>
        </div>
    </div>

    <!-- ESP32 Integration Note -->
    <div class="mt-8 bg-blue-50 border border-blue-200 rounded-xl p-6">
        <h3 class="text-lg font-semibold text-blue-800 mb-3">
            <i class="fas fa-satellite-dish text-blue-500 mr-2"></i>ESP32 Integration
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <p class="text-blue-700 mb-3">
                    To connect your ESP32, send POST requests to:
                </p>
                <div class="bg-gray-800 text-green-300 p-4 rounded-lg font-mono text-sm">
                    POST <?php echo e(url('/sensors/store')); ?><br>
                    Headers: Content-Type: application/json<br>
                    Body: {<br>
                    &nbsp;&nbsp;"temperature": 25.5,<br>
                    &nbsp;&nbsp;"humidity": 60.2,<br>
                    &nbsp;&nbsp;"soil_moisture": 450<br>
                    }
                </div>
            </div>
            <div>
                <p class="text-blue-700 mb-3">
                    Get latest motor status:
                </p>
                <div class="bg-gray-800 text-green-300 p-4 rounded-lg font-mono text-sm">
                    GET <?php echo e(url('/motor/status')); ?><br>
                    Response: {<br>
                    &nbsp;&nbsp;"status": "on/off",<br>
                    &nbsp;&nbsp;"last_activated_at": "timestamp"<br>
                    }
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    let countdown = 10;
    
    // Update countdown
    function updateCountdown() {
        countdown--;
        $('#refresh-countdown').text(countdown);
        
        if (countdown <= 0) {
            countdown = 10;
            refreshSensorData();
        }
    }
    
    setInterval(updateCountdown, 1000);
    
    function refreshSensorData() {
        $.get("<?php echo e(route('sensors.latest')); ?>", function(data) {
            // Update live readings
            $('#live-temperature').text(data.temperature + '°');
            $('#live-humidity').text(data.humidity + '%');
            $('#live-soil-moisture').text(data.soil_moisture);
            
            // Update timestamps
            const time = new Date(data.updated_at).toLocaleTimeString();
            $('#temp-timestamp').text(time);
            $('#humidity-timestamp').text(time);
            $('#soil-timestamp').text(time);
            
            // Update progress bar
            const soilWidth = Math.min(data.soil_moisture / 10.23, 100);
            $('.bg-gradient-to-r').css('width', soilWidth + '%');
        });
    }
    
    // Initial refresh
    refreshSensorData();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\SmartIrrigation\resources\views/sensors/index.blade.php ENDPATH**/ ?>